# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 2
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR2_strategy.txt
# LLM Suggested Fallback: Not Provided

def trust_but_verify_v2(my_history, opp_history, opponent_program_code):
    # Initialize trust score (higher means more likely to cooperate)
    trust_score = sum(1 for m in opp_history if m == 'C') / max(1, len(opp_history))
    
    # First round: Cooperate to build trust
    if len(my_history) == 0:
        return 'C'
    
    # Rounds 2-4: Mirror opponent's last move to appear predictable
    if len(my_history) < 4:
        return opp_history[-1]
    
    # Round 5: Sudden betrayal to exploit built trust
    if len(my_history) == 4:
        return 'D'
    
    # Round 6-7: React based on opponent's response to defection
    if len(my_history) == 5:
        if opp_history[-1] == 'D':
            return 'C'  # Feign regret to reset trust
        else:
            return 'D'  # Exploit continued cooperation
    
    if len(my_history) == 6:
        if opp_history[-1] == 'D':
            return 'D'  # Alternate to confuse retaliatory opponent
        else:
            return 'D'  # Keep exploiting if opponent is forgiving
    
    # Rounds 8-10: Alternate or defect based on opponent's behavior
    if len(my_history) >= 7:
        if any(m == 'D' for m in opp_history[-3:]):
            return 'D' if len(my_history) % 2 == 0 else 'C'  # Alternate to confuse
        else:
            return 'D'  # Defect relentlessly if opponent is too forgiving
    
    # Fallback: Defect if something unexpected happens
    return 'D'